/*
 * Decompiled with CFR 0.152.
 */
package arc.mf.model.asset;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ContentState
extends Enum {
    public static final /* enum */ ContentState NONE = new ContentState("NONE", 0, "Asset has no content");
    public static final /* enum */ ContentState ONLINE = new ContentState("ONLINE", 1, "The content is local to the server and should be fast to retrieve");
    public static final /* enum */ ContentState OFFLINE = new ContentState("OFFLINE", 2, "The content is not local to the server (remote or offline), and may take a while to retrieve");
    public static final /* enum */ ContentState ONLINE_AND_OFFLINE = new ContentState("ONLINE_AND_OFFLINE", 3, "The content is local to the server as well as having a copy in offline storage and should be fast to retrieve");
    public static final /* enum */ ContentState SCHEDULED = new ContentState("SCHEDULED", 4, "The content has been scheduled for retrieval, but is not yet online");
    public static final /* enum */ ContentState COPYING_ONLINE = new ContentState("COPYING_ONLINE", 5, "Content is currently being migrated to online storage");
    public static final /* enum */ ContentState COPYING_OFFLINE = new ContentState("COPYING_OFFLINE", 6, "Content is online - copying to offline storage");
    public static final /* enum */ ContentState UNKNOWN = new ContentState("UNKNOWN", 7, "Out of the control/visibility of the server");
    public static final /* enum */ ContentState INVALID = new ContentState("INVALID", 8, "The is an error accessing the content");
    public static final /* enum */ ContentState MISSING = new ContentState("MISSING", 9, "The content is no longer available/visible");
    public static final /* enum */ ContentState REACHABLE = new ContentState("REACHABLE", 10, "The external system containig the content can be reached");
    public static final /* enum */ ContentState UNREACHABLE = new ContentState("UNREACHABLE", 11, "The external system containing the content cannot be reached");
    public static final /* enum */ ContentState REMOTE = new ContentState("REMOTE", 12, "Content is stored in another server and may take some time to retreive");
    public static final /* enum */ ContentState DEGRADED = new ContentState("DEGRADED", 13, "The content has multiple copies but one or more of the copies is not available, the checksums don't match or it's in error");
    private String a;
    private static final /* synthetic */ ContentState[] a;

    public static ContentState[] values() {
        return (ContentState[])a.clone();
    }

    public static ContentState valueOf(String string) {
        return Enum.valueOf(ContentState.class, string);
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private ContentState() {
        void var3_2;
        void var2_-1;
        void var1_-1;
        this.a = var3_2;
    }

    public String description() {
        return this.a;
    }

    public static ContentState status(String string, String string2) {
        if (string == null) {
            return UNKNOWN;
        }
        if (string.equalsIgnoreCase("no content")) {
            return NONE;
        }
        if (string.equalsIgnoreCase("remote")) {
            return REMOTE;
        }
        if (string.equalsIgnoreCase("online")) {
            return ONLINE;
        }
        if (string.equalsIgnoreCase("offline")) {
            return OFFLINE;
        }
        if (string.equalsIgnoreCase("online+offline")) {
            return ONLINE_AND_OFFLINE;
        }
        if (string.equalsIgnoreCase("scheduled")) {
            return SCHEDULED;
        }
        if (string.equalsIgnoreCase("migrating")) {
            if (string2.equalsIgnoreCase("online")) {
                return COPYING_ONLINE;
            }
            return COPYING_OFFLINE;
        }
        if (string.equalsIgnoreCase("unknown")) {
            return UNKNOWN;
        }
        if (string.equalsIgnoreCase("missing")) {
            return MISSING;
        }
        if (string.equalsIgnoreCase("reachable")) {
            return REACHABLE;
        }
        if (string.equalsIgnoreCase("unreachable")) {
            return UNREACHABLE;
        }
        if (string.equalsIgnoreCase("invalid")) {
            return INVALID;
        }
        if (string.equalsIgnoreCase("degraded")) {
            return DEGRADED;
        }
        return UNKNOWN;
    }

    public boolean immediatelyDownloadable() {
        switch (this) {
            case NONE: 
            case OFFLINE: 
            case SCHEDULED: 
            case COPYING_ONLINE: 
            case UNKNOWN: 
            case MISSING: 
            case UNREACHABLE: 
            case INVALID: {
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ ContentState[] a() {
        return new ContentState[]{NONE, ONLINE, OFFLINE, ONLINE_AND_OFFLINE, SCHEDULED, COPYING_ONLINE, COPYING_OFFLINE, UNKNOWN, INVALID, MISSING, REACHABLE, UNREACHABLE, REMOTE, DEGRADED};
    }

    static {
        a = ContentState.a();
    }
}

