/*
 * Decompiled with CFR 0.152.
 */
package arc.dtype;

public enum Fuzzy implements Comparable
{
    YES,
    NO,
    MAYBE,
    UNKNOWN;


    public static Fuzzy fuzzy(String string) {
        Fuzzy[] fuzzyArray;
        if (string == null) {
            return null;
        }
        for (Fuzzy fuzzy : fuzzyArray = Fuzzy.values()) {
            if (!fuzzy.name().equalsIgnoreCase(string)) continue;
            return fuzzy;
        }
        throw new AssertionError((Object)("There is no Fuzzy type: " + string));
    }

    public static Fuzzy booleanValue(boolean bl2) {
        if (bl2) {
            return YES;
        }
        return NO;
    }

    public boolean yes() {
        return this.equals(YES);
    }

    public boolean no() {
        return this.equals(NO);
    }

    public boolean maybe() {
        switch (this) {
            case MAYBE: {
                return true;
            }
        }
        return false;
    }

    public boolean explicitAndDifferent(Fuzzy fuzzy) {
        if (fuzzy.equals(UNKNOWN)) {
            return false;
        }
        return !fuzzy.equals(this);
    }

    public boolean maybeOrUnknown() {
        switch (this) {
            case MAYBE: 
            case UNKNOWN: {
                return true;
            }
        }
        return false;
    }
}

